<?php
require 'fpdf/fpdf.php';

class PDF extends FPDF
{
// Cabecera de página
function Header()
{
   	$this->Image('imagenes/puerto.jpg',10,7,16);
	
	$this->SetFont('helvetica','B',12);
	$this->Text(28,14,'GAM - PUERTO VILLARROEL',0,'C', 0);
    
	$this->SetFont('helvetica','',10);
	$this->Text(28,18,'5TA SECC. PROV. CARRASCO',0,'C', 0);
	
	$this->SetFont('helvetica','',10);
	$this->Text(28,22,'Ivirgarzama - Cochabamba',0,'C', 0);
	
	$this->SetFont('helvetica','',10);
	$this->Text(28,27,'NIT: 124913020',0,'C', 0);
	
	$this->SetFont('helvetica','',10);
	$this->Text(80,31,'UNIDAD DE RECURSOS HUMANOS',0,'C', 0);
	
	
	$this->SetFont('helvetica','',10);
	$this->Text(10,32,'___________________________________________________________________________________________________',0,'C', 0);
	
	
	// Arial bold 15
    $this->SetFont('Arial','B',15);
    // Movernos a la derecha
    $this->Cell(85);
    // Título
    $this->Cell(30,30,'REPORTE DE VIAJES 2023',0,0,'C');
    // Salto de línea
    $this->Ln(28);
	
		$this->Cell(20);
		$this->SetFont('Arial','B',8);
	    $this->cell(15,7,'C.I',1,0,'C',0);
		$this->cell(65,7,'NOMBRES',1,0,'C',0);
		//$this->cell(30,7,'MOTIVO VIAJE',1,0,'',0);
		$this->cell(30,7,'FECHA REGISTRO',1,0,'C',0);
		$this->cell(20,7,'DESDE',1,0,'C',0);
		$this->cell(20,7,'HASTA',1,1,'C',0);
	
}

// Pie de página
function Footer()
{
    // Posición: a 1,5 cm del final
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','I',8);
    // Número de página
    $this->Cell(0,10,'Pagina '.$this->PageNo().'/{nb}',0,0,'C');
}
}

require 'conexionD.php';

$consulta="SELECT TP.numDoc_per as ci, concat(TP.nom_per,' ', TP.primerAp_per,' ', TP.segundoAp_per) as nombres, CV.fechaReg_viaj as fecha_registro, CV.fecha_inc as desde, CV.fecha_fin as hasta from t_comision_viajes CV INNER JOIN t_personales TP on CV.id_per=TP.id_per   where fechaReg_viaj between '2023-01-01' and '2023-12-31'  and estado is NULL  ORDER BY fechaReg_viaj ASC ;";
$resultado=$mysqli->query($consulta);



$pdf = new PDF('P','mm','Letter');
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','',8);



while($row=$resultado->fetch_assoc()){
		$pdf->Cell(20);
		$pdf->Cell(15,7,utf8_encode($row['ci']),'B',0,'',0);
		$pdf->Cell(65,7,utf8_encode($row['nombres']),'B',0,'',0);
		// $pdf->MultiCell(30,7,utf8_encode($row['motivo_viaj']),1,0,'',0);
		$pdf->Cell(30,7,utf8_encode($row['fecha_registro']),'B',0,'',0);
		$pdf->Cell(20,7,utf8_encode($row['desde']),'B',0,'',0);		
		$pdf->Cell(20,7,utf8_encode($row['hasta']),'B',1,'',0);

		
		
			 						
	}
	



	

$pdf->Output();
?>